/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceMp4AvcCscStruct;
import jpcsp.HLE.modules.sceDmacplus;
import jpcsp.HLE.modules.sceMpegbase;
import jpcsp.Memory;
import jpcsp.mediaengine.MEMemory;
import jpcsp.mediaengine.MEProcessor;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.memory.mmio.dmac.DmacProcessor;
import jpcsp.scheduler.Scheduler;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class MMIOHandlerDmacplus
extends MMIOHandlerBase {
    public static Logger log = sceDmacplus.log;
    private static final int STATE_VERSION = 0;
    public static final int COMPLETED_FLAG_UNKNOWN = 1;
    public static final int COMPLETED_FLAG_AVC = 2;
    public static final int COMPLETED_FLAG_SC2ME = 4;
    public static final int COMPLETED_FLAG_ME2SC = 8;
    public static final int COMPLETED_FLAG_SC128_MEMCPY = 16;
    private final DmacProcessor[] dmacProcessors = new DmacProcessor[3];
    private int flagsCompleted;
    private int flagsError;
    private int displayFrameBufferAddr;
    private int displayWidth;
    private int displayFrameBufferWidth;
    private int displayPixelFormatCoded;
    public static final int DISPLAY_FLAG_ENABLED = 1;
    public static final int DISPLAY_FLAG_UNKNOWN = 2;
    private int displayFlags;
    private final int[] mpegAvcYuvBuffers = new int[8];
    private int mpegAvcWidth;
    private int mpegAvcHeight;
    private int mpegAvcMode0;
    private int mpegAvcMode1;
    private int mpegAvcBufferWidth;
    private int mpegAvcInternalPixelMode;
    private int mpegAvcBufferUnknownPresent;
    private int mpegAvcBufferRGB;
    private int mpegAvcBufferUnknown;
    private final int[] mpegAvcCodes = new int[4];
    private IAction mpegAvcCompletedAction;

    public MMIOHandlerDmacplus(int baseAddress) {
        super(baseAddress);
        MEMemory meMemory = MEProcessor.getInstance().getMEMemory();
        Memory scMemory = this.getMemory();
        this.dmacProcessors[0] = new DmacProcessor(scMemory, meMemory, baseAddress + 384, new DmacCompletedAction(4));
        this.dmacProcessors[1] = new DmacProcessor(meMemory, scMemory, baseAddress + 416, new DmacCompletedAction(8));
        this.dmacProcessors[2] = new DmacProcessor(scMemory, scMemory, baseAddress + 448, new DmacCompletedAction(16));
        this.mpegAvcCompletedAction = new DmacCompletedAction(2);
        this.updateDisplay();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.flagsCompleted = stream.readInt();
        this.flagsError = stream.readInt();
        for (int i = 0; i < this.dmacProcessors.length; ++i) {
            this.dmacProcessors[i].read(stream);
        }
        this.displayFrameBufferAddr = stream.readInt();
        this.displayWidth = stream.readInt();
        this.displayFrameBufferWidth = stream.readInt();
        this.displayPixelFormatCoded = stream.readInt();
        this.displayFlags = stream.readInt();
        super.read(stream);
        this.updateDisplay();
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.flagsCompleted);
        stream.writeInt(this.flagsError);
        for (int i = 0; i < this.dmacProcessors.length; ++i) {
            this.dmacProcessors[i].write(stream);
        }
        stream.writeInt(this.displayFrameBufferAddr);
        stream.writeInt(this.displayWidth);
        stream.writeInt(this.displayFrameBufferWidth);
        stream.writeInt(this.displayPixelFormatCoded);
        stream.writeInt(this.displayFlags);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.flagsCompleted = 0;
        this.flagsError = 0;
        for (int i = 0; i < this.dmacProcessors.length; ++i) {
            this.dmacProcessors[i].reset();
        }
        this.displayFrameBufferAddr = 0;
        this.displayWidth = 0;
        this.displayFrameBufferWidth = 0;
        this.displayPixelFormatCoded = 0;
        this.displayFlags = 0;
        this.updateDisplay();
    }

    private void setCompleted(int flagCompleted) {
        this.flagsCompleted |= flagCompleted;
        this.checkInterrupt();
    }

    private void checkInterrupt() {
        if (this.flagsCompleted != 0) {
            RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 21);
        } else {
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), 21);
        }
    }

    public void setDisplayFrameBufferAddr(int displayFrameBufferAddr) {
        if (this.displayFrameBufferAddr != displayFrameBufferAddr) {
            this.displayFrameBufferAddr = displayFrameBufferAddr;
            this.updateDisplay();
        }
    }

    public void setDisplayWidth(int displayWidth) {
        this.displayWidth = displayWidth;
    }

    public void setDisplayFrameBufferWidth(int displayFrameBufferWidth) {
        if (this.displayFrameBufferWidth != displayFrameBufferWidth) {
            this.displayFrameBufferWidth = displayFrameBufferWidth;
            this.updateDisplay();
        }
    }

    public void setDisplayPixelFormat(int displayPixelFormatCoded) {
        if (this.displayPixelFormatCoded != displayPixelFormatCoded) {
            this.displayPixelFormatCoded = displayPixelFormatCoded;
            this.updateDisplay();
        }
    }

    public void setDisplayFlags(int displayFlags) {
        if (this.displayFlags != displayFlags) {
            this.displayFlags = displayFlags;
            this.updateDisplay();
        }
    }

    private void updateDisplay() {
        int displayPixelFormat = sceDmacplus.pixelFormatFromCode[this.displayPixelFormatCoded & 3];
        int frameBufferAddr = this.displayFrameBufferAddr;
        if ((this.displayFlags & 1) == 0) {
            frameBufferAddr = 0;
        }
        if (this.displayFrameBufferWidth == 0) {
            frameBufferAddr = 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("updateDisplay.hleDisplaySetFrameBuf frameBufferAddr=0x%08X, displayFrameBufferWidth=0x%X, displayPixelFormat=0x%X, displayFlags=0x%X", frameBufferAddr, this.displayFrameBufferWidth, displayPixelFormat, this.displayFlags));
        }
        Modules.sceDisplayModule.hleDisplaySetFrameBuf(frameBufferAddr, this.displayFrameBufferWidth, displayPixelFormat, 0);
        Modules.sceDisplayModule.step();
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 4: {
                value = this.flagsCompleted;
                break;
            }
            case 12: {
                value = this.flagsError;
                break;
            }
            case 256: {
                value = this.displayFrameBufferAddr;
                break;
            }
            case 260: {
                value = this.displayPixelFormatCoded;
                break;
            }
            case 264: {
                value = this.displayWidth;
                break;
            }
            case 268: {
                value = this.displayFrameBufferWidth;
                break;
            }
            case 272: {
                value = this.displayFlags;
                break;
            }
            case 336: {
                value = this.mpegAvcCodes[0];
                break;
            }
            case 340: {
                value = this.mpegAvcCodes[1];
                break;
            }
            case 344: {
                value = this.mpegAvcCodes[2];
                break;
            }
            case 348: {
                value = this.mpegAvcCodes[3];
                break;
            }
            case 384: 
            case 388: 
            case 392: 
            case 396: 
            case 400: {
                value = this.dmacProcessors[0].read32(address - this.baseAddress - 384);
                break;
            }
            case 416: 
            case 420: 
            case 424: 
            case 428: 
            case 432: {
                value = this.dmacProcessors[1].read32(address - this.baseAddress - 416);
                break;
            }
            case 448: 
            case 452: 
            case 456: 
            case 460: 
            case 464: {
                value = this.dmacProcessors[2].read32(address - this.baseAddress - 448);
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    private void setMpegAvc140(int value) {
        this.mpegAvcHeight = value >> 16 & 0x3F;
        this.mpegAvcWidth = value >> 8 & 0x3F;
        this.mpegAvcMode0 = value >> 2 & 1;
        this.mpegAvcMode1 = value >> 1 & 1;
    }

    private void setMpegAvc14C(int value) {
        this.mpegAvcBufferWidth = value >>> 8;
        this.mpegAvcInternalPixelMode = value >> 1 & 3;
        this.mpegAvcBufferUnknownPresent = value >> 0 & 1;
    }

    private void setMpegAvcCmd(int cmd) {
        switch (cmd) {
            case 0: {
                break;
            }
            case 13: {
                if (this.mpegAvcCodes[0] != 213909653 || this.mpegAvcCodes[1] != 965687445 || this.mpegAvcCodes[2] != 264341 || this.mpegAvcCodes[3] != 272) {
                    log.error((Object)String.format("setMpegAvcCmd sceMpegBaseCscAvc unknown mpegAvcCodes 0x%08X, 0x%08X, 0x%08X, 0x%08X", this.mpegAvcCodes[0], this.mpegAvcCodes[1], this.mpegAvcCodes[2], this.mpegAvcCodes[3]));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("setMpegAvcCmd sceMpegBaseCscAvc bufferRGB=0x%08X, bufferUnknown=0x%08X, width=0x%X, height=0x%X, bufferWidth=0x%X, mode0=0x%X, mode1=0x%X, internalPixelMode=0x%X, bufferUnknownPresent=0x%X", this.mpegAvcBufferRGB, this.mpegAvcBufferUnknown, this.mpegAvcWidth, this.mpegAvcHeight, this.mpegAvcBufferWidth, this.mpegAvcMode0, this.mpegAvcMode1, this.mpegAvcInternalPixelMode, this.mpegAvcBufferUnknownPresent));
                }
                int pixelMode = sceMpegbase.getPixelMode(this.mpegAvcInternalPixelMode);
                TPointer bufferRGB = new TPointer(Emulator.getMemory(this.mpegAvcBufferRGB), this.mpegAvcBufferRGB);
                TPointer bufferUnknown = this.mpegAvcBufferUnknownPresent != 0 ? new TPointer(Emulator.getMemory(this.mpegAvcBufferUnknown), this.mpegAvcBufferUnknown) : TPointer.NULL;
                SceMp4AvcCscStruct mp4AvcCscStruct = new SceMp4AvcCscStruct();
                mp4AvcCscStruct.height = this.mpegAvcHeight;
                mp4AvcCscStruct.width = this.mpegAvcWidth;
                mp4AvcCscStruct.mode0 = this.mpegAvcMode0;
                mp4AvcCscStruct.mode1 = this.mpegAvcMode1;
                mp4AvcCscStruct.buffer0 = this.mpegAvcYuvBuffers[0];
                mp4AvcCscStruct.buffer1 = this.mpegAvcYuvBuffers[1];
                mp4AvcCscStruct.buffer2 = this.mpegAvcYuvBuffers[2];
                mp4AvcCscStruct.buffer3 = this.mpegAvcYuvBuffers[3];
                mp4AvcCscStruct.buffer4 = this.mpegAvcYuvBuffers[4];
                mp4AvcCscStruct.buffer5 = this.mpegAvcYuvBuffers[5];
                mp4AvcCscStruct.buffer6 = this.mpegAvcYuvBuffers[6];
                mp4AvcCscStruct.buffer7 = this.mpegAvcYuvBuffers[7];
                mp4AvcCscStruct.bufferMemory = MEProcessor.getInstance().getMEMemory();
                Modules.sceMpegbaseModule.hleMpegBaseCscAvc(bufferRGB, bufferUnknown, this.mpegAvcBufferWidth, pixelMode, mp4AvcCscStruct);
                Scheduler.getInstance().addAction(Scheduler.getNow() + 3000L, this.mpegAvcCompletedAction);
                break;
            }
            default: {
                log.error((Object)String.format("setMpegAvcCmd unknown cmd=0x%X", cmd));
            }
        }
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 8: {
                this.flagsCompleted &= ~value;
                this.checkInterrupt();
                break;
            }
            case 16: {
                this.flagsError &= ~value;
                break;
            }
            case 256: {
                this.setDisplayFrameBufferAddr(value);
                break;
            }
            case 260: {
                this.setDisplayPixelFormat(value);
                break;
            }
            case 264: {
                this.setDisplayWidth(value);
                break;
            }
            case 268: {
                this.setDisplayFrameBufferWidth(value);
                break;
            }
            case 272: {
                this.setDisplayFlags(value);
                break;
            }
            case 288: {
                this.mpegAvcYuvBuffers[0] = value;
                break;
            }
            case 292: {
                this.mpegAvcYuvBuffers[1] = value;
                break;
            }
            case 296: {
                this.mpegAvcYuvBuffers[2] = value;
                break;
            }
            case 300: {
                this.mpegAvcYuvBuffers[3] = value;
                break;
            }
            case 304: {
                this.mpegAvcYuvBuffers[4] = value;
                break;
            }
            case 308: {
                this.mpegAvcYuvBuffers[5] = value;
                break;
            }
            case 312: {
                this.mpegAvcYuvBuffers[6] = value;
                break;
            }
            case 316: {
                this.mpegAvcYuvBuffers[7] = value;
                break;
            }
            case 320: {
                this.setMpegAvc140(value);
                break;
            }
            case 324: {
                this.mpegAvcBufferRGB = value;
                break;
            }
            case 328: {
                this.mpegAvcBufferUnknown = value;
                break;
            }
            case 332: {
                this.setMpegAvc14C(value);
                break;
            }
            case 336: {
                this.mpegAvcCodes[0] = value;
                break;
            }
            case 340: {
                this.mpegAvcCodes[1] = value;
                break;
            }
            case 344: {
                this.mpegAvcCodes[2] = value;
                break;
            }
            case 348: {
                this.mpegAvcCodes[3] = value;
                break;
            }
            case 352: {
                this.setMpegAvcCmd(value);
                break;
            }
            case 384: 
            case 388: 
            case 392: 
            case 396: 
            case 400: {
                this.dmacProcessors[0].write32(address - this.baseAddress - 384, value);
                break;
            }
            case 416: 
            case 420: 
            case 424: 
            case 428: 
            case 432: {
                this.dmacProcessors[1].write32(address - this.baseAddress - 416, value);
                break;
            }
            case 448: 
            case 452: 
            case 456: 
            case 460: 
            case 464: {
                this.dmacProcessors[2].write32(address - this.baseAddress - 448, value);
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    private class DmacCompletedAction
    implements IAction {
        private int flagCompleted;

        public DmacCompletedAction(int flagCompleted) {
            this.flagCompleted = flagCompleted;
        }

        @Override
        public void execute() {
            MMIOHandlerDmacplus.this.setCompleted(this.flagCompleted);
        }
    }
}

